// random.c

#include "main.h"
#include "random.h"

unsigned long randomSeed[2], pieceCount[2], grenadeTimer[2];
int pieceMap[kBlobTypes], numPieces;

void InitRandom( int inNumPieces )
{
	int count, swap, swapWith;
	
	numPieces = inNumPieces;
	randomSeed[0] = randomSeed[1] = Random();
	pieceCount[0] = pieceCount[1] = 0;
	grenadeTimer[0] = grenadeTimer[1] = 40;
	
	for( count=0; count<kBlobTypes; count++ )
	{
		pieceMap[count] = count+1;
	}

	for( count=0; count<kBlobTypes; count++ )
	{
		swapWith = RandomBefore( kBlobTypes );
		swap = pieceMap[swapWith];
		pieceMap[swapWith] = pieceMap[count];
		pieceMap[count] = swap;
	}
}

void AddExtraPiece( void )
{
	numPieces++;
}

int GetPiece( int player )
{
	int result;
	long realSeed;
	
	realSeed = GetQDGlobalsRandomSeed();
	
	SetQDGlobalsRandomSeed(randomSeed[player]);
	result = pieceMap[RandomBefore(numPieces)];
	randomSeed[player] = GetQDGlobalsRandomSeed();
	
	SetQDGlobalsRandomSeed(realSeed);

	return result;
}

int GetMagic( int player )
{
	int result;
	long realSeed;
	
	realSeed = GetQDGlobalsRandomSeed();
	
	SetQDGlobalsRandomSeed(randomSeed[player]);
	result = (RandomBefore(19) == 0)? true: false;
	randomSeed[player] = GetQDGlobalsRandomSeed();
	
	SetQDGlobalsRandomSeed(realSeed);

	return result;
}

int GetGrenade( int player )
{
	pieceCount[player]++;
	if( pieceCount[player] == grenadeTimer[player] )
	{
		grenadeTimer[player] += grenadeTimer[player] * 3 / 2;
		return true;
	}
	else
	{
		return false;
	}
}

static inline int RandomRange( double min, double max )
{
	const double kMinRand = -32767.0;
	const double kMaxRand =  32767.0;
	double x;
	
	x = (Random() - kMinRand) / (kMaxRand - kMinRand + 1.0);
	return (x * (max + 1.0 - min) + min);
}

int RandomBefore( int what )
{	
	return RandomRange( 0.0, what-1 );
}

